-- ui screen events

floweramount = 35;
flowerpositions = {}


karma_tokens = 0
phase = -1
soundplayed = 0
timer = 0
timerclick = 0
totalkarmaaddition = 0
previouskarma = 0

clickdelay = 0.06
pausedelay = 0.25

function OnLoad ()
	CacheSound ("music/levelcomplete.ogg");
	CacheSound ("ui/sfx/button-over.ogg");
	CacheSound ("sfx/appear_ice_effect.ogg");
	CacheSound ("sfx/smallclick.ogg");
	NX_GetBitmap("board/piece-03.png");
	
end;

game_completed = false;

function resetComplete ()

	totalkarmaaddition = 0
	karma_tokens = 0
	phase = -1
	soundplayed = 0
	timer = 0
	timerclick = 0
	SetProperty("yourtime:visible", 0);
	SetProperty("besttime:visible", 0);
	SetProperty("timeleft:visible", 0);
	SetProperty ("timebonus:label.text", "|ffc600|0");
	SetProperty ("karmacollected:label.text", "|ffc600|0");
	SetProperty ("bonusesactivated:label.text", "|ffc600|0");
	SetProperty ("progressitems:label.text", "|ffc600|0");
	previouskarma = GetGameValue("karma_tokens") - GetGameValue("level_karma_collected");
	if(previouskarma < 0) then
		previouskarma = 0;		
	end;	
	SetProperty ("karmatotal:label.text", "|ffc600|"..previouskarma);
	SetProperty ("karmathislevel:label.text", "|ffc600|"..totalkarmaaddition);
end;

function OnEnter ()

	SaveLevelScore ();

  resetComplete()
  
  for i = 1, floweramount, 1 do
  		temp = {}
		y = math.random(40,700);
		temp.y = y - (y*2);		
		temp.x = math.random(0,800);
		table.insert(flowerpositions, i, temp);
  end;

  StopMusic (3.0); -- the parm is the fade out time
	PlaySound ("music/levelcomplete.ogg");

	-- get the required info to show here and set the next level after that
	SetProperty ("level_short_name:label.text", GetGameValue ("level_short_name"));
	SetProperty ("level_long_name:label.text", GetGameValue ("level_long_name"));

	
	
	-- !! level completed needs to add the level number OnEnter if the game has levels !!
	--    The game state should also be saved right here so that player won't lose
	--    any progress if s/he chooses to close the window at this point or whatver.
	level_number = GetGameValue ("level_number");
	the_last_level = GetGameValue ("number_of_levels");
  
	if (level_number == the_last_level) then
		DeleteGameState ();	-- it was the last level, the game is completed
		game_completed = true;
	else
		-- set the next level
		SetGameValue ("level_number", level_number+1);
		SaveGameState ("WorldMap");		
		game_completed = false;
	end; 
end;

function OnLeave ()
		
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "reset") then
		resetComplete()
	end;
	
	if (name == "Ok") then
		karma = previouskarma+totalkarmaaddition
		print("Karma: " .. karma .. " prevkarma: " .. previouskarma .. " addition: " .. totalkarmaaddition);
		SetGameValue("karma_tokens", previouskarma+totalkarmaaddition);
		SaveGameState ("WorldMap");	
		PopScreen ("Game");
		--SetProperty ("yourtime:label.text", "")
		--SetProperty ("besttime:label.text", "")
		--PopScreen ("LevelCompleted");		
		if (game_completed) then
			SwitchScreen ("GameCompleted");
		else
			SwitchScreen ("WorldMap");
			
		end		
		return;
	end;
	
end;


function OnUpdate (tdelta)

	
	timer = timer+tdelta
	
	-- start the animation
	if(timer > 0.4 and phase == -1) then
		phase = 0
	end;
	
	if(phase == 0) then
		-- time in seconds		
		if(soundplayed == 0) then
			yourtime = string.format("%d", GetGameValue ("level_time") / 1000)	
			SetProperty ("yourtime:label.text", "|ffc600|"..yourtime.." sec.")
			spawnAppearFx("yourtime")
			SetProperty ("yourtime:visible", 1);
			PlaySound ("sfx/appear_ice_effect.ogg");
			soundplayed = 1
		end;
		if(timer > 0.8) then
			phase = 1
			soundplayed = 0
		end;
	end;
	
	if(phase == 1) then
		
		if(soundplayed == 0) then
			-- TODO: get record holder here
			recordholder = "|00d8ff|Pertti: "
			-- time in seconds		
			-- TODO: get best time here
			besttime = string.format("%d", GetGameValue ("level_time") / 1000)
			SetProperty ("besttime:label.text", recordholder.."|ffc600|"..besttime.." sec.");	
			spawnAppearFx("besttime")
			--SpawnFX ("fxs/hammer-hit.lua", 100,100, 180, 0);
			SetProperty ("besttime:visible", 1);
			PlaySound ("sfx/appear_ice_effect.ogg");
			soundplayed = 1
		end;
		if(timer > 1.2) then
			phase = 2
			soundplayed = 0
		end;
	end;
	
	if(phase == 2) then
		if(soundplayed == 0) then
			timeleft = string.format("%d", GetGameValue ("level_time") / 1000)
			SetProperty ("timeleft:label.text", "|ffc600|"..timeleft.." sec.");
			spawnAppearFx("timeleft")
			SetProperty ("timeleft:visible", 1);
			PlaySound ("sfx/appear_ice_effect.ogg");
			soundplayed = 1
		end;
		if(timer > 1.6) then
			phase = 3
			soundplayed = 0
		end;
	end;
		
	-- pause
    if(phase == 3) then
    	if(soundplayed == 0) then
			soundplayed = 1
			timerclick = timer
		end;	
		if((timer - timerclick) > (pausedelay/2)) then
			phase = 4
			soundplayed = 0
		end;
	end;
		
	-- time bonus
	if(phase == 4) then
		if(soundplayed == 0) then
			karma_tokens = 0
			soundplayed = 1
		end;		
		if(karma_tokens < (120/30) and (timer - timerclick) > (clickdelay*1.2)) then
			karma_tokens = karma_tokens + 1;
			totalkarmaaddition = totalkarmaaddition + 1;
			SetProperty ("timebonus:label.text", "|ffc600|"..karma_tokens);
			spawnKarma("karmatotal")
			PlaySound ("sfx/smallclick.ogg");
			timerclick = timer
		end;		
		if(karma_tokens >= (120/30)) then
			phase = 5
			soundplayed = 0
			PlaySound ("sfx/appear_ice_effect.ogg");
		end;
	end;

	
    -- pause
    if(phase == 5) then
    	if(soundplayed == 0) then
			soundplayed = 1
			timerclick = timer
		end;	
		if((timer - timerclick) > pausedelay) then
			phase = 6
			soundplayed = 0
		end;
	end;
	
    if(phase == 6) then
		if(soundplayed == 0) then
			karma_tokens = 0
			soundplayed = 1
		end;		
		if(karma_tokens < GetGameValue ("level_karma_collected") and (timer - timerclick) > (clickdelay*1.2)) then
			karma_tokens = karma_tokens + 1;
			totalkarmaaddition = totalkarmaaddition + 1;
			SetProperty ("karmacollected:label.text", "|ffc600|"..karma_tokens);
			spawnKarma("karmatotal")
			PlaySound ("sfx/smallclick.ogg");
			timerclick = timer
		end;		
		if(karma_tokens >= GetGameValue ("level_karma_collected")) then
			phase = 7
			soundplayed = 0
			PlaySound ("sfx/appear_ice_effect.ogg");
		end;
	end;
	
	-- pause
    if(phase == 7) then
    	if(soundplayed == 0) then
			soundplayed = 1
			timerclick = timer
		end;	
		if((timer - timerclick) > pausedelay) then
			phase = 8
			soundplayed = 0
		end;
	end;
	
	if(phase == 8) then
		if(soundplayed == 0) then
			karma_tokens = 0
			soundplayed = 1
		end;		
		if(karma_tokens < GetGameValue ("level_bonuses_activated") and (timer - timerclick) > clickdelay) then
			karma_tokens = karma_tokens + 1;
			SetProperty ("bonusesactivated:label.text", "|ffc600|"..karma_tokens);
			PlaySound ("ui/sfx/button-over.ogg");
			timerclick = timer
		end;		
		if(karma_tokens >= GetGameValue ("level_bonuses_activated")) then
			phase = 9
			soundplayed = 0
			PlaySound ("sfx/appear_ice_effect.ogg");
		end;
	end;
	
	-- pause
    if(phase == 9) then
    	if(soundplayed == 0) then
			soundplayed = 1
			timerclick = timer
		end;	
		if((timer - timerclick) > pausedelay) then
			phase = 10
			soundplayed = 0
		end;
	end;
	
	if(phase == 10) then
		if(soundplayed == 0) then
			karma_tokens = 0
			soundplayed = 1
		end;		
		if(karma_tokens < GetGameValue ("level_progress_items") and (timer - timerclick) > clickdelay) then
			karma_tokens = karma_tokens + 1;
			SetProperty ("progressitems:label.text", "|ffc600|"..karma_tokens);
			PlaySound ("ui/sfx/button-over.ogg");
			timerclick = timer
		end;		
		if(karma_tokens >= GetGameValue ("level_progress_items")) then
			phase = 11
			soundplayed = 0
			PlaySound ("sfx/appear_ice_effect.ogg");
		end;
	end;
	
	
	SetProperty ("karmathislevel:label.text", "|ffc600|"..totalkarmaaddition);
	SetProperty ("karmatotal:label.text", "|ffc600|"..(previouskarma+totalkarmaaddition));
	
	
	
	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("heading:position_offset.y", (1-trans) * 700 * -1);
	SetProperty ("panel:alpha", trans);
	SetProperty ("bgpicture:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));
	
	for i = 1, floweramount, 1 do
		if(flowerpositions[i]["y"] < 700) then
			flowerpositions[i]["y"] = flowerpositions[i]["y"] + (100 * tdelta);		
		else	
  			--Print("ENDFLOWERFLY flower" .. i .. "\n");
  			y = math.random(40,700);
			y = y - (y*2);		
			x = math.random(0,800);
			flowerpositions[i]["y"] = y
			flowerpositions[i]["x"] = x
		end;
		
	end;

end;

function spawnKarma(name)
	x = GetProperty(name..":static_position.x");
	y = GetProperty(name..":static_position.y");
	width = GetProperty(name..":width");
	SpawnFX ("fxs/karma_token.lua", x+width/2, y, 180, 0);	
end;

function spawnAppearFx(name)

	x = GetProperty(name..":static_position.x");
	y = GetProperty(name..":static_position.y");
	width = GetProperty(name..":width");
	SpawnFX ("fxs/appear_cloud.lua", x+width/2, y, 180, 0);	
	SpawnFX ("fxs/appear_cloud.lua", x, y, 180, 0);	
	SpawnFX ("fxs/appear_cloud.lua", x+width, y, 180, 0);	
end;

function OnDraw ()
	
	for i = 1, floweramount, 1 do
		sinewave = 35 * math.sin((flowerpositions[i]["y"] / 80));
		rotationsine = 25 * math.sin((flowerpositions[i]["y"] / 30));
		scale = flowerpositions[i]["y"] / 700 + 0.5;
		NX_DrawBitmapRS ("board/piece-03.png", flowerpositions[i]["x"]+sinewave, flowerpositions[i]["y"], rotationsine/180*3.1415926535, scale);
	end;

end;
